"""UCTS Core module - context management, models, and hooks"""

from ucts.core.context_manager import UniversalContextManager, get_ucts
from ucts.core.models import Session, Message, CodeBlock, ProjectStructure
from ucts.core.hooks import (
    ForgeHooks,
    HookPhase,
    HookResult,
    HookContext,
    HookResponse,
    get_forge_hooks,
    reset_hooks,
)

__all__ = [
    # Context management
    "UniversalContextManager",
    "get_ucts",
    # Models
    "Session",
    "Message",
    "CodeBlock",
    "ProjectStructure",
    # Hooks
    "ForgeHooks",
    "HookPhase",
    "HookResult",
    "HookContext",
    "HookResponse",
    "get_forge_hooks",
    "reset_hooks",
]
