"""UCTS Generators Module - Project generation for VS Code, GitLab, GitHub, Docker, Cloud, K8s, Tests"""

from ucts.generators.vscode import VSCodeGenerator
from ucts.generators.gitlab import GitLabGenerator
from ucts.generators.github import GitHubGenerator
from ucts.generators.docker import DockerGenerator, DockerConfig, add_docker_to_project
from ucts.generators.merger import ProjectMerger, MergeStrategy, MergeResult
from ucts.generators.cloud import (
    CloudGenerator,
    CloudConfig,
    AWSGenerator,
    GCPGenerator,
    AzureGenerator,
    VercelGenerator,
    RailwayGenerator,
)
from ucts.generators.kubernetes import (
    KubernetesGenerator,
    K8sConfig,
    HelmGenerator,
)
from ucts.generators.tests import (
    TestGenerator,
    TestConfig,
    PytestGenerator,
    JestGenerator,
    VitestGenerator,
)

__all__ = [
    # VS Code / Git platforms
    "VSCodeGenerator",
    "GitLabGenerator",
    "GitHubGenerator",
    # Docker
    "DockerGenerator",
    "DockerConfig",
    "add_docker_to_project",
    # Merger
    "ProjectMerger",
    "MergeStrategy",
    "MergeResult",
    # Cloud deployment
    "CloudGenerator",
    "CloudConfig",
    "AWSGenerator",
    "GCPGenerator",
    "AzureGenerator",
    "VercelGenerator",
    "RailwayGenerator",
    # Kubernetes
    "KubernetesGenerator",
    "K8sConfig",
    "HelmGenerator",
    # Tests
    "TestGenerator",
    "TestConfig",
    "PytestGenerator",
    "JestGenerator",
    "VitestGenerator",
]
