"""UCTS Integrations Module - Coherence Ecosystem Integrations"""

from ucts.integrations.coherence import CoherenceIntegration
from ucts.integrations.sentinel import (
    SentinelIntegration,
    SecurityScanResult,
    PolicyDecision,
    ViolationSeverity,
)
from ucts.integrations.ecosystem import (
    EcosystemManager,
    EcosystemConfig,
    IntegrationMode,
    get_ecosystem,
    reset_ecosystem,
)
from ucts.integrations.gcu import (
    GCUIntegration,
    TrustTier,
    AlertSeverity,
)
from ucts.integrations.danai import (
    DanAIIntegration,
    CostTier,
    AgentStatus,
)
from ucts.integrations.mmb import (
    MMBIntegration,
    CodePattern,
)
from ucts.integrations.wb2 import (
    WB2Integration,
    ForgeMetrics,
)
from ucts.integrations.sdk_mode import (
    EcosystemSDK,
    SDKConfig,
    SDKMode,
    EventType,
    Event,
    A2AMessage,
    get_ecosystem_sdk,
    initialize_sdk,
)

__all__ = [
    # Core integrations
    "CoherenceIntegration",
    "SentinelIntegration",

    # Ecosystem manager
    "EcosystemManager",
    "EcosystemConfig",
    "IntegrationMode",
    "get_ecosystem",
    "reset_ecosystem",

    # GCU
    "GCUIntegration",
    "TrustTier",
    "AlertSeverity",

    # DanAI
    "DanAIIntegration",
    "CostTier",
    "AgentStatus",

    # MMB
    "MMBIntegration",
    "CodePattern",

    # WB2
    "WB2Integration",
    "ForgeMetrics",

    # Sentinel security
    "SecurityScanResult",
    "PolicyDecision",
    "ViolationSeverity",

    # SDK Mode
    "EcosystemSDK",
    "SDKConfig",
    "SDKMode",
    "EventType",
    "Event",
    "A2AMessage",
    "get_ecosystem_sdk",
    "initialize_sdk",
]
