"""UCTS Team/Enterprise Features"""

from ucts.team.features import (
    TeamManager,
    TeamConfig,
    SharedLibrary,
    AuditLog,
    AuditEntry,
    Permission,
    Role,
    get_team_manager,
)

from ucts.team.auth import (
    AuthManager,
    AuthConfig,
    AuthProvider,
    AuthToken,
    AuthSession,
    UserIdentity,
    OAuth2Provider,
    SAMLProvider,
    APIKeyProvider,
    get_azure_ad_config,
    get_okta_config,
    get_google_config,
    get_github_config,
)

__all__ = [
    # Team Features
    "TeamManager",
    "TeamConfig",
    "SharedLibrary",
    "AuditLog",
    "AuditEntry",
    "Permission",
    "Role",
    "get_team_manager",
    # Authentication
    "AuthManager",
    "AuthConfig",
    "AuthProvider",
    "AuthToken",
    "AuthSession",
    "UserIdentity",
    "OAuth2Provider",
    "SAMLProvider",
    "APIKeyProvider",
    # Provider configs
    "get_azure_ad_config",
    "get_okta_config",
    "get_google_config",
    "get_github_config",
]
