"""
UCTS Project Templates - Pre-built scaffolding for common frameworks
"""

from ucts.templates.base import ProjectTemplate, TemplateRegistry
from ucts.templates.python_templates import (
    FastAPITemplate,
    FlaskTemplate,
    DjangoTemplate,
    CLITemplate,
)
from ucts.templates.node_templates import (
    ExpressTemplate,
    NextJSTemplate,
    ViteReactTemplate,
)

# Global registry
registry = TemplateRegistry()

# Register built-in templates
registry.register(FastAPITemplate())
registry.register(FlaskTemplate())
registry.register(DjangoTemplate())
registry.register(CLITemplate())
registry.register(ExpressTemplate())
registry.register(NextJSTemplate())
registry.register(ViteReactTemplate())


def get_template(name: str) -> ProjectTemplate:
    """Get a template by name"""
    return registry.get(name)


def list_templates():
    """List all available templates"""
    return registry.list_all()


__all__ = [
    "ProjectTemplate",
    "TemplateRegistry",
    "registry",
    "get_template",
    "list_templates",
    "FastAPITemplate",
    "FlaskTemplate",
    "DjangoTemplate",
    "CLITemplate",
    "ExpressTemplate",
    "NextJSTemplate",
    "ViteReactTemplate",
]
